<?php

namespace YOOtheme\Theme\Wordpress\WooCommerce\Listener;

use YOOtheme\Config;
use YOOtheme\Path;
use WooCommerce;
use WPML\Convert\Ids;

class LoadCustomizer
{
    public Config $config;

    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    public function handle(): void
    {
        if (class_exists(WooCommerce::class, false)) {

            $cartId = wc_get_page_id('cart');

            if (class_exists(Ids::class, true)) {
                $cartId = Ids::convert($cartId, 'page', true);
            }

            $this->config->set('woocommerce.cartPage', (int) $cartId);
            $this->config->addFile(
                'customizer',
                Path::get('../../config/customizer.json', __DIR__),
            );
        }
    }
}
